custom_fixes = {
    "تكيف": "تَكَيُّف",
    "بقاء": "بَقَّااء",
    "قدرة": "قُدرَة",
    "نقل": "نَقْل",
    "دب": "دُبّ",
    "نمر": "نَمِر",
    "فرو": "فَروُ",
    "بني": "بُنّي",
    "ملونة": "مِلوِنَةْ",
    "قوس قزح": "قُوس قُزَح",
    "معينة": "مُعيَّنَة",
    "فنك": "فنِك",
    "حر": "حَر",
    "شم": "شَمْ",
    "بصر": "بَصَر",
    "أذن": "اُذُن",
    "فم": "فَم",
    "عين": "عِين",
    "لهث": "لَّهْث",
    "قطط": "قطط",
    "لنقل": "لنَقْل",
    "قدم": "قَدَمْ",
    "مية": "مَيَّةْ",
    "حاسِّة": "حاسة",
    "دهون": "دُهون",
    "طاقة": "طاقّةْ",
    "اللي": "اللِّي",
    "نزل": "نِزْل",
    "شفت": "شُفْت",
    "تل": "تَل",
    "مخزن": "مَخزَّن",
    "زنبرك": "زُنبرُك",
    "ايه": "إِيه",
    "أيه": "إِيه",
    "خَلِية": "خلية",
    "بيضة": "بِيضةْ",
    "جنين": "جَنين",
    "نسل": "نَسْل",
    "ذكر": "ذَكَر",
    "جوا": "جُوَّا",
    "قولي": "قُولِّي",
    "زي": "زَيّ",
    "يخصب": "يِخَصَب",
    "يخرج": "يِخرُج",
    "تكاثر": "تَكاثُر",
    "بابا": "بَابَا",
    "ماما": "مَامَا",
    "اساعد": "أَساعد",
    "اكسجين": "اُكسُچين",
    "وصل": "وِصِل",
    "ولد": "وَلَد",
    "انثى": "أُنثى",
    "الميكروسكوب": "المايكروسكوب",
    "تندمج": "تَنْدَمِج",
    "توضيح": "تَوْضيح",
    "الشعر": "الشَعر",
    "زرقاء": "زَرْقاء",
    "اشقر": "أَشْقَر",
    "تكبر": "تِكبر",
    "حلقة": "حَلَقَةْ",
    "حبة": "حَبَةْ",
    "يربط": "يِرْبُط",
    "كيس": "كِيس",
    "مرن": "مَرِن",
    "نتناول": "نَتَنَاوَل",
    "ننتقل": "تَنَتَقِل",
    "قصة": "قِصةْ",
    "تختبر": "تَخَتَبِر",
    "إزيك": "إزَيَّك",
    "بيئتها": "بِيئِتهَا",
    "بقاء": "بَقَاء",
    "جمل": "جَمَل",
    "السمع": "السَّمْع",
    "الشم": "الشَّم",
    "الأذنين": "الْأُذُنَيْن",
    "طاقه": "طَاقَه",
    "السيتوبلازم": "السِيتُوبلازم",
    "جزيئات": "جُزَيئات",
    "اسرع": "اَسْرَع",
    "تسخن": "تَسَخْن",
    "معلقه": "مَعَلَّقَه",
    "بتتدحرج": "بِتِتدَحرَج",
    "وضعها": "وَضَعِهَا",
    "تنقبض": "تَنْقَبِض",
    "اللاإرادية": "اللاَإِرَادية",
    "عضله": "عَضَلَه",
    "عضلات": "عَضَلَات",
    "بنأكله": "بِنأكْلُه",
    "الهضم": "الْهَضْم",
    "منصة": "مَنَصّةْ",
    "أساعدك": "أَساعدك",
    "النهارده": "النهاردَه"

}



import re

def apply_fixes(text, fixes_dict):
    prefixes = "(ال|يت|مت|بـ|بي|بن)?"
    suffixes = "(ات|ها|هم|ه|ي|ون|ين|ة|ً)?"

    for wrong, fixed in fixes_dict.items():
        pattern = rf"\b{prefixes}{wrong}{suffixes}\b"

        def replacer(m):
            prefix = m.group(1) or ""
            suffix = m.group(2) or ""
            return prefix + fixed + suffix

        text = re.sub(pattern, replacer, text)
    
    return text
