from pydantic import BaseModel

class TTSConfig(BaseModel):
    """Holds configuration for a single TTS model."""
    language: str
    model_name_or_path: str
    speaker_wav: str
    config_path: str | None = None
    vocab_path: str | None = None


ARABIC_MODEL_CONFIG = TTSConfig(
    language="ar",
    model_name_or_path="./model/EGTTS-V0.1/",
    speaker_wav="calm_anan_1.wav",
    config_path="./model/EGTTS-V0.1/config.json",
    vocab_path="./model/EGTTS-V0.1/vocab.json"
)

ENGLISH_MODEL_CONFIG = TTSConfig(
    language="en",
    model_name_or_path="tts_models/multilingual/multi-dataset/xtts_v2",
    speaker_wav="calm_anan_1.wav"
)


SUPPORTED_MODELS = {
    "ar": ARABIC_MODEL_CONFIG,
    "en": ENGLISH_MODEL_CONFIG,
}