#!/bin/bash
set -e

# Run the database readiness check
/app/wait-for-postgres.sh

echo "Setting up schema and inserting data..."
python apply_test_schema.py
python insert_csv_embeddings.py
echo "Database setup complete."
python curriculum_structure.py
echo "Curriculum structure setup complete."
python setup_mcq_table.py
echo "MCQ table setup complete."

sleep 5
# Start the web server and keep it as the main process
exec gunicorn -c gunicorn.conf.py main:app
