import sys
import os
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..')))
from core import MessageType, ResponseStatus


class TextMessageHandler:
    def __init__(self):
        pass  # No dependencies needed for text handling

    def handle(self, text: str, **kwargs) -> dict:
        """Process text message - simple validation and pass-through"""
        try:
            if not text or not text.strip():
                raise ValueError("Text message cannot be empty")
            
            print(f"Processing text message: {text[:50]}...")
            
            return {
                "status": ResponseStatus.SUCCESS,
                "message": "Text message processed successfully",
                "text": text.strip(),
                "message_type": MessageType.TEXT
            }
            
        except Exception as e:
            print(f"Error processing text message: {e}")
            return {
                "status": ResponseStatus.ERROR,
                "message": f"Failed to process text: {str(e)}",
                "message_type": MessageType.TEXT
            }