from pydantic import BaseModel
from typing import List, Optional

class QuestionResponse(BaseModel):
    """Defines the exact 11 fields to be returned for each question."""
    question_text: str
    question_type: Optional[str] = None
    correct_answer: str
    wrong_answer_1: Optional[str] = None
    wrong_answer_2: Optional[str] = None
    wrong_answer_3: Optional[str] = None
    wrong_answer_4: Optional[str] = None
    difficulty_level: Optional[int] = None
    blooms_level: Optional[str] = None
    is_arabic: bool
    hint: Optional[str] = None

    class Config:
        orm_mode = True # This helps Pydantic work with dictionary-like objects

class QuizResponse(BaseModel):
    """Defines the structure for the quiz endpoints."""
    status: str
    message: str
    quiz: List[QuestionResponse]

class MCQListResponse(BaseModel):
    """Defines the structure for the GET /mcq endpoint."""
    status: str
    count: int
    questions: List[QuestionResponse]