import time
from typing import Optional
import sys
import os
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..')))
from core import AppConfig
from repositories import StorageRepository

class HealthService:
    def __init__(self, storage_repo: StorageRepository, config: AppConfig):
        self.storage_repo = storage_repo
        self.config = config

    def get_health_status(self) -> dict:
        minio_status = self.storage_repo.check_connection(self.config.minio_bucket)
        
        return {
            "status": "healthy",
            "service": "unified-chat-api-local-agent",
            "minio_status": minio_status,
            "timestamp": time.time()
        }