import os
import torch
import torchaudio
from TTS.tts.configs.xtts_config import XttsConfig
from TTS.tts.models.xtts import Xtts

CONFIG_FILE_PATH = './model/EGTTS-V0.1/config.json'
VOCAB_FILE_PATH = './model/EGTTS-V0.1/vocab.json'
MODEL_PATH = './model/EGTTS-V0.1/'

print("Loading model...")
config = XttsConfig()
config.load_json(CONFIG_FILE_PATH)
model = Xtts.init_from_config(config)
model.load_checkpoint(config, checkpoint_dir=MODEL_PATH, use_deepspeed=False, vocab_path=VOCAB_FILE_PATH)

# move model to GPU if available

if torch.cuda.is_available():
    model.cuda()
    print("Model moved to GPU.")

    
# compute speaker latents
SPEAKER_AUDIO_PATH = 'calm_anan_1.wav'
print("Computing speaker latents...")
gpt_cond_latent, speaker_embedding = model.get_conditioning_latents(audio_path=[SPEAKER_AUDIO_PATH])


text = """
انا عنان مؤسس شرع العلوم وانا هنا عشان اساعدك تتعلم اي حاجة عايز تتعلمها فالعلوم
انا شرع العلوم موقع تعليمي بيقدم كورسات مجانية في مجالات متعددة زي البرمجة، التصميم، التسويق، وغيرها
كل اللي عليك تعمله تزور الموقع وتختار الكورس اللي يناسبك وتبدأ تتعلم على طول من غير اي تكلفة
تحب تتعلم ايه النهاردة؟
اي اسئلة عندك انا هنا عشان اساعدك
اي استفسار انا تحت امرك
اسال زي ما انت عايز
في اي مجال تحب تتعلم اكتر؟
"""
print("Inference...")
out = model.inference(
    text,
    "ar",
    gpt_cond_latent,
    speaker_embedding,
    temperature=0.1,
)

AUDIO_OUTPUT_PATH = "output_audio.wav"

import soundfile as sf
sf.write(AUDIO_OUTPUT_PATH, out["wav"], 24000)

