#!/bin/bash
# wait-for-postgres.sh

set -e

host="postgres"
port="5432"
dbname="${POSTGRES_DB}"
user="${POSTGRES_USER}"
password="${POSTGRES_PASSWORD}"

echo "Waiting for PostgreSQL..."

until PGPASSWORD=$password pg_isready -h $host -p $port -U $user; do
  echo "PostgreSQL is unavailable - sleeping"
  sleep 1
done

echo "PostgreSQL is up - executing command"
exec "$@"