from fastapi import APIRouter, UploadFile, File, Form, BackgroundTasks
from fastapi.responses import FileResponse
from fastapi import HTTPException
import os
from pathlib import Path
import sys
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..')))
from process_pdf_pipline import process_pdf_curriculum_in_background

router = APIRouter(tags=["Curriculum"])



@router.get("/curriculum-upload")
async def serve_curriculum_upload():
    """Serve the curriculum upload HTML file"""
    try:
        static_file = Path("static/curriculum_PDF_uploader.html")
        if static_file.exists():
            return FileResponse(static_file)
        current_file = Path("curriculum_PDF_uploader.html")
        if current_file.exists():   
            return FileResponse(current_file)
        raise HTTPException(status_code=404, detail="Curriculum upload interface not found")
    except Exception as e:
        print(f"Error serving curriculum upload interface: {e}")
        raise HTTPException(status_code=500, detail=f"Error serving interface: {str(e)}")
    

    


@router.post("/process-curriculum", status_code=202)
async def process_curriculum_webhook(
    background_tasks: BackgroundTasks,
    grade: int = Form(...), 
    subject: str = Form(...),
    file: UploadFile = File(...)
                                ):
    """
    Accepts a PDF and adds a background task to process it.
    Returns immediately.
    """
    pdf_bytes = await file.read()
    

    background_tasks.add_task(
        process_pdf_curriculum_in_background, 
        pdf_bytes, 
        file.filename,
        grade,
        subject
    )
    
    # Return immediately to the user
    return {"status": "processing_started", "message": "The curriculum is being processed in the background."}
