from fastapi import APIRouter, HTTPException
from fastapi.responses import FileResponse
from pathlib import Path

router = APIRouter(tags=["Frontend"])

def serve_html(filename: str):
    try:
        static_file = Path(f"static/{filename}")
        if static_file.exists(): return FileResponse(static_file)
        current_file = Path(filename)
        if current_file.exists(): return FileResponse(current_file)
        raise HTTPException(status_code=404, detail=f"{filename} not found")
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))
    
@router.get("/")
async def serve_homepage():
    """Serve the main homepage HTML file"""
    return serve_html("index.html")

@router.get("/live-quiz")
async def serve_live_quiz_interface():
    """Serve the live quiz HTML file"""
    return serve_html("live_quiz_interface.html")

@router.get("/quiz-interface")
async def serve_quiz_interface():
    """Serve the quiz interface HTML file"""
    return serve_html("dynamic_quiz_interface.html")


@router.get("/chat-interface")
async def serve_chat_interface():
    """Serve the chat interface HTML file"""
    return serve_html("audio-recorder.html")

@router.get("/test-yourself")
async def serve_test_yourself_interface():
    """Serve the interactive 'Test Yourself' HTML file"""
    return serve_html("test_yourself_interface.html")

@router.get("/curriculum-upload")
async def serve_curriculum_upload():
    """Serve the curriculum upload HTML file"""
    return serve_html("curriculum_PDF_uploader.html")