# services/response_manager.py

import time
from typing import Optional

class ResponseManager:
    def __init__(self):
        # Initialize with the new 'audio_bytes' key
        self._latest_response = {"text": None, "audio_filename": None, "audio_bytes": None, "timestamp": 0}

    # --- MODIFIED: Added the 'audio_bytes' parameter ---
    def store_response(self, text: str, audio_filename: Optional[str] = None, audio_bytes: Optional[bytes] = None) -> None:
        """Store response with text, audio filename, and raw audio bytes."""
        self._latest_response = {
            "text": text,
            "audio_filename": audio_filename,
            "audio_bytes": audio_bytes, # <-- Store the bytes
            "timestamp": time.time()
        }

    def get_response(self) -> dict:
        return self._latest_response.copy()

    def clear_response(self) -> None:
        # Clear all fields
        self._latest_response = {"text": None, "audio_filename": None, "audio_bytes": None, "timestamp": 0}

    def is_response_fresh(self, max_age_seconds: int = 300) -> bool:
        # The logic remains the same
        return (self._latest_response["text"] and 
                (time.time() - self._latest_response["timestamp"] < max_age_seconds))