import time
from typing import Optional

class ResponseManager:
    def __init__(self):
        self._latest_response = {"text": None, "audio_file_path": None, "timestamp": 0}

    def store_response(self, text: str, audio_file_path: Optional[str] = None) -> None:
        self._latest_response = {
            "text": text,
            "audio_file_path": audio_file_path,
            "timestamp": time.time()
        }

    def get_response(self) -> dict:
        return self._latest_response.copy()

    def clear_response(self) -> None:
        self._latest_response = {"text": None, "audio_file_path": None, "timestamp": 0}

    def is_response_fresh(self, max_age_seconds: int = 300) -> bool:
        return (self._latest_response["text"] and 
                (time.time() - self._latest_response["timestamp"] < max_age_seconds))
