using UnityEngine;
using UnityEngine.EventSystems;
using DG.Tweening;

public class ClickEffect : MonoBehaviour, IPointerDownHandler
{
    [SerializeField] private AudioClip soundClip;
    [SerializeField] private float punchStrength = 0.2f;
    [SerializeField] private float duration = 0.3f;

    private Vector3 originalScale;

    void Start()
    {
        originalScale = transform.localScale;
    }

    public void OnPointerDown(PointerEventData eventData)
    {
        transform.DOComplete();
        transform.localScale = originalScale;
        transform.DOPunchScale(Vector3.one * punchStrength, duration, 10, 1);

        if (AudioManager.Instance != null)
        {
            AudioManager.Instance.PlaySound(soundClip);
        }
        else
        {
            Debug.LogWarning("No AudioManager found in scene!");
        }
    }
}