using UnityEngine;
using DG.Tweening;

public class FloatingAnimation : MonoBehaviour
{
    [Header("Floating Settings")]
    public float floatDistance = 0.5f;       // Up & down distance
    public float floatDuration = 1.5f;       // Time for one up/down movement
    public Ease floatEase = Ease.InOutSine;  // Floating curve

    [Header("Rotation Settings")]
    public Vector3 rotationAxes = new Vector3(0, 1, 0); // Which axes to rotate (1 = enabled)
    public float rotationAngle = 10f;                 // Max rotation angle
    public float rotationDuration = 2f;               // Time for one sway
    public Ease rotationEase = Ease.InOutSine;        // Rotation curve

    private Vector3 startPos;
    private Vector3 startRot;

    void Start()
    {
        startPos = transform.localPosition;
        startRot = transform.localEulerAngles;

        transform.DOLocalMoveY(startPos.y + floatDistance, floatDuration)
            .SetEase(floatEase)
            .SetLoops(-1, LoopType.Yoyo);

        Vector3 targetRot = startRot + new Vector3(
            rotationAxes.x != 0 ? rotationAngle : 0,
            rotationAxes.y != 0 ? rotationAngle : 0,
            rotationAxes.z != 0 ? rotationAngle : 0
        );

        transform.DOLocalRotate(targetRot, rotationDuration)
            .SetEase(rotationEase)
            .SetLoops(-1, LoopType.Yoyo);
    }
    private void OnDestroy()
    {
        DOTween.Kill(transform);
    }
}
